/*
 * Decompiled with CFR 0.152.
 */
package info.loenwind.autoconfig;

import info.loenwind.autoconfig.factory.ByteBufAdapters;
import info.loenwind.autoconfig.factory.IRootFactory;
import info.loenwind.autoconfig.util.Log;
import info.loenwind.autoconfig.util.NullHelper;
import java.io.File;
import javax.annotation.Nullable;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.fml.client.event.ConfigChangedEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public class ConfigHandler {
    protected final File configDirectory;
    protected final Configuration config;
    protected final IRootFactory factory;

    public ConfigHandler(FMLPreInitializationEvent event, IRootFactory factory) {
        this(event, factory, null);
    }

    public ConfigHandler(FMLPreInitializationEvent event, IRootFactory factory, @Nullable String folder) {
        this.factory = factory;
        ByteBufAdapters.NONE.getClass();
        MinecraftForge.EVENT_BUS.register((Object)this);
        this.configDirectory = folder != null ? new File(event.getModConfigurationDirectory(), folder) : NullHelper.notnullF(event.getModConfigurationDirectory(), "FMLPreInitializationEvent has no config folder");
        if (!this.configDirectory.exists()) {
            this.configDirectory.mkdir();
        }
        File configFile = new File(this.configDirectory, factory.getModid() + ".cfg");
        this.config = new Configuration(configFile);
        this.syncConfig();
    }

    public void syncConfig() {
        try {
            this.factory.setConfig(this.config);
        }
        catch (Exception e) {
            Log.error(this.factory.getModid() + " has a problem loading its configuration:");
            e.printStackTrace();
        }
        finally {
            if (this.config.hasChanged()) {
                this.config.save();
            }
        }
    }

    @SubscribeEvent
    public void onConfigChanged(ConfigChangedEvent.OnConfigChangedEvent event) {
        if (event.getModID().equals(this.factory.getModid())) {
            Log.info("Updating config...");
            this.syncConfig();
        }
    }
}

